﻿<%@ Page Title="" Language="C#" MasterPageFile="~/SecureArea/SA.master" AutoEventWireup="true" CodeBehind="editProtocollo.aspx.cs" Inherits="Protocollo.SecureArea.editProtocollo" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="asp" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <script language="javascript" type="text/javascript">
        function OpenFile(file) {
            if (file != null) {
                window.open("../files/" + file, "_blank");
            }
        }
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:ToolkitScriptManager ID="ToolkitScriptManager1" runat="server">
    </asp:ToolkitScriptManager>
    <div id="container">
        <fieldset class="protocollo">
        <legend>Gestione protocollo</legend>

            Ricerca&nbsp;
            <asp:TextBox ID="tbSearch" runat="server"></asp:TextBox>
            &nbsp;<asp:ImageButton ID="ImageButton2" runat="server" 
                ImageUrl="~/icons/magnifier.png" onclick="ImageButton2_Click" />
            <br />
            <br />
            Visualizza:
            <asp:DropDownList ID="ddVisualizza" runat="server" AutoPostBack="True" 
                    onselectedindexchanged="ddVisualizza_SelectedIndexChanged">
                <asp:ListItem>Tutto</asp:ListItem>
                <asp:ListItem>Ultimo mese E/U</asp:ListItem>
                <asp:ListItem>Entrata</asp:ListItem>
                <asp:ListItem>Uscita</asp:ListItem>
                <asp:ListItem>Ultimo mese Entrata</asp:ListItem>
                <asp:ListItem>Ultimo mese Uscita</asp:ListItem>
            </asp:DropDownList>

            <br />
            <br />
            <asp:GridView ID="gvProtocollo" runat="server" CellPadding="4" ForeColor="Black" 
                GridLines="Vertical" AllowPaging="True" 
                AutoGenerateColumns="False" BackColor="White" BorderColor="#DEDFDE" 
                BorderStyle="None" BorderWidth="1px" onrowdatabound="gvProtocollo_RowDataBound" 
                onsorting="gvProtocollo_Sorting" 
                onpageindexchanging="gvProtocollo_PageIndexChanging">
                <AlternatingRowStyle BackColor="White" />
                <Columns>
                    <asp:BoundField DataField="ID" Visible="False" />
                    <asp:BoundField DataField="e_u" HeaderText="E/U" />
                    <asp:BoundField DataField="Ambito" HeaderText="Ambito" 
                        SortExpression="Ambito" />
                    <asp:BoundField DataField="Numero" HeaderText="Numero" SortExpression="Numero">
                    <HeaderStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                    <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                    </asp:BoundField>
                    <asp:BoundField DataField="Data" HeaderText="Data" SortExpression="Data">
                    <HeaderStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                    <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                    </asp:BoundField>
                    <asp:BoundField DataField="Oggetto" HeaderText="Oggetto" 
                        SortExpression="Oggetto" />
                    <asp:BoundField DataField="Mittente" HeaderText="Mittente" 
                        SortExpression="Mittente" />
                    <asp:BoundField DataField="Destinatario" HeaderText="Destinatario" 
                        SortExpression="Destinatario" />
                    <asp:BoundField DataField="Note" HeaderText="Note" SortExpression="Note" />
                    <asp:TemplateField HeaderText="File">
                        <ItemTemplate>
                            <asp:ImageButton ID="ImageButton1" runat="server" ImageUrl="~/icons/page.png" 
                                Visible='<%# Eval("FilePathVisible") %>' />
                        </ItemTemplate>
                        <HeaderStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                        <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                    </asp:TemplateField>
                    <asp:BoundField DataField="Utente" HeaderText="Utente" 
                        SortExpression="Utente" />
                    <asp:TemplateField HeaderText="Mod.">
                        <ItemTemplate>
                            <asp:ImageButton ID="imbMod" runat="server" CommandArgument='<%# Eval("ID") %>' 
                                ImageUrl="~/icons/edit_16.png" onclick="imbMod_Click" />
                        </ItemTemplate>
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle HorizontalAlign="Center" />
                    </asp:TemplateField>
                </Columns>
                <FooterStyle BackColor="#CCCC99" />
                <HeaderStyle BackColor="#6B696B" Font-Bold="True" ForeColor="White" />
                <PagerStyle BackColor="#F7F7DE" ForeColor="Black" HorizontalAlign="Right" />
                <RowStyle BackColor="#F7F7DE" />
                <SelectedRowStyle BackColor="#CE5D5A" Font-Bold="True" ForeColor="White" />
                <SortedAscendingCellStyle BackColor="#FBFBF2" />
                <SortedAscendingHeaderStyle BackColor="#848384" />
                <SortedDescendingCellStyle BackColor="#EAEAD3" />
                <SortedDescendingHeaderStyle BackColor="#575357" />
            </asp:GridView>

        </fieldset>
    </div>
</asp:Content>
